<?php

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Каталог туров';
?>
<div class="tour-catalog">
    <div class="card">
        <div class="card-header">
            <h2><i class="fas fa-compass"></i> <?= Html::encode($this->title) ?></h2>
        </div>
        
        <div class="card-body">
            <?php if (empty($tours)): ?>
                <div class="empty-state">
                    <i class="fas fa-map-marker-alt fa-3x"></i>
                    <h3>Туры не найдены</h3>
                    <p>В данный момент нет доступных туров</p>
                </div>
            <?php else: ?>
                <div class="tours-grid">
                    <?php foreach ($tours as $tour): ?>
                    <div class="tour-card">
                        <div class="tour-image">
                            <?= Html::img('/images/tours/default.jpg', [
                                'alt' => $tour->name,
                                'class' => 'tour-img'
                            ]) ?>
                            <div class="tour-price"><?= number_format($tour->price, 0, ',', ' ') ?> ₽</div>
                        </div>
                        
                        <div class="tour-info">
                            <h3 class="tour-title"><?= Html::encode($tour->name) ?></h3>
                            
                            <div class="tour-meta">
                                <span><i class="fas fa-calendar"></i> <?= $tour->duration_days ?> дн.</span>
                                <span><i class="fas fa-users"></i> до <?= $tour->max_participants ?> чел.</span>
                            </div>
                            
                            <p class="tour-description">
                                <?= Html::encode(mb_substr($tour->description, 0, 100)) ?>...
                            </p>
                            
                            <div class="tour-actions">
                                <?= Html::a('Подробнее', ['tour/view', 'id' => $tour->id], [
                                    'class' => 'btn btn-primary'
                                ]) ?>
                                
                                <?php if (!Yii::$app->user->isGuest): ?>
                                    <?= Html::a('Забронировать', ['application/create', 'tour_id' => $tour->id], [
                                        'class' => 'btn btn-success'
                                    ]) ?>
                                <?php else: ?>
                                    <?= Html::a('Забронировать', ['auth/login'], [
                                        'class' => 'btn btn-success'
                                    ]) ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
.tour-catalog {
    padding: 20px 0;
}

.empty-state {
    text-align: center;
    padding: 40px 20px;
    color: #7f8c8d;
}

.empty-state i {
    margin-bottom: 20px;
}

.tours-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
    gap: 20px;
    margin-top: 20px;
}

.tour-card {
    background: white;
    border: 1px solid #ddd;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    transition: transform 0.3s;
}

.tour-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.2);
}

.tour-image {
    position: relative;
    height: 180px;
    overflow: hidden;
}

.tour-img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.tour-price {
    position: absolute;
    top: 10px;
    right: 10px;
    background: #3498db;
    color: white;
    padding: 5px 10px;
    border-radius: 5px;
    font-weight: bold;
    font-size: 18px;
}

.tour-info {
    padding: 15px;
}

.tour-title {
    font-size: 18px;
    margin-bottom: 10px;
    color: #2c3e50;
}

.tour-meta {
    display: flex;
    gap: 15px;
    margin-bottom: 10px;
    color: #7f8c8d;
    font-size: 14px;
}

.tour-meta i {
    margin-right: 5px;
}

.tour-description {
    color: #5d6d7e;
    line-height: 1.5;
    margin-bottom: 15px;
    font-size: 14px;
}

.tour-actions {
    display: flex;
    gap: 10px;
}

.tour-actions .btn {
    flex: 1;
    text-align: center;
    padding: 8px 10px;
    font-size: 14px;
}

@media (max-width: 768px) {
    .tours-grid {
        grid-template-columns: 1fr;
    }
    
    .tour-actions {
        flex-direction: column;
    }
}
</style>