<?php

use yii\helpers\Html;
use app\assets\AppAsset;

AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <?= Html::csrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?> | Туры выходного дня</title>
    <?php $this->head() ?>
    <style>
        /* Базовые стили */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            background: #f5f5f5;
            color: #333;
            line-height: 1.6;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        /* ОЧЕНЬ ПРОСТАЯ ШАПКА */
        .site-header {
            background: #2c3e50;
            color: white;
            padding: 15px 0;
            width: 100%;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }

        .header-content {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }

        /* Первая строка: лого и кнопки входа */
        .header-top {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }

        .site-logo {
            font-size: 24px;
            font-weight: bold;
            color: white;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .site-logo:hover {
            color: #3498db;
        }

        .auth-buttons {
            display: flex;
            gap: 10px;
        }

        /* Кнопки - ОЧЕНЬ ПРОСТЫЕ */
        .btn {
            padding: 8px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            text-align: center;
        }

        .btn-primary {
            background: #3498db;
            color: white;
        }

        .btn-primary:hover {
            background: #2980b9;
        }

        .btn-outline {
            background: transparent;
            border: 1px solid #3498db;
            color: #3498db;
        }

        .btn-outline:hover {
            background: #3498db;
            color: white;
        }

        .btn-danger {
            background: #e74c3c;
            color: white;
        }

        .btn-danger:hover {
            background: #c0392b;
        }

        /* Вторая строка: основное меню */
        .main-nav {
            background: #34495e;
            padding: 10px 0;
            border-radius: 4px;
        }

        .nav-menu {
            list-style: none;
            display: flex;
            justify-content: center;
            gap: 20px;
            flex-wrap: wrap;
        }

        .nav-menu a {
            color: white;
            text-decoration: none;
            padding: 8px 15px;
            border-radius: 4px;
            display: flex;
            align-items: center;
            gap: 8px;
            white-space: nowrap;
        }

        .nav-menu a:hover {
            background: #3498db;
        }

        /* Информация о пользователе - ПРОСТАЯ */
        .user-panel {
            display: flex;
            align-items: center;
            gap: 15px;
            background: #34495e;
            padding: 10px 15px;
            border-radius: 4px;
            margin-bottom: 15px;
        }

        .user-avatar {
            color: #3498db;
            font-size: 20px;
        }

        .user-details {
            flex: 1;
        }

        .user-name {
            font-weight: bold;
            font-size: 14px;
            color: white;
        }

        .user-email {
            font-size: 12px;
            color: #bdc3c7;
        }

        .user-role {
            background: #3498db;
            color: white;
            padding: 2px 8px;
            border-radius: 10px;
            font-size: 11px;
        }

        .user-role.admin {
            background: #e74c3c;
        }

        /* Основной контент */
        .main-content {
            flex: 1;
            padding: 30px 0;
            min-height: calc(100vh - 200px);
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }

        /* Карточки */
        .card {
            background: white;
            border: 1px solid #ddd;
            border-radius: 6px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }

        .card-header {
            background: #2c3e50;
            color: white;
            padding: 15px;
            margin: -20px -20px 20px -20px;
            border-radius: 6px 6px 0 0;
        }

        /* Сообщения */
        .alert {
            padding: 15px;
            border-radius: 4px;
            margin: 15px 0;
            border: 1px solid transparent;
        }

        .alert-success {
            background: #d4edda;
            color: #155724;
            border-color: #c3e6cb;
        }

        .alert-danger {
            background: #f8d7da;
            color: #721c24;
            border-color: #f5c6cb;
        }

        .alert-info {
            background: #d1ecf1;
            color: #0c5460;
            border-color: #bee5eb;
        }

        /* Подвал */
        .site-footer {
            background: #2c3e50;
            color: white;
            padding: 30px 0 20px;
            margin-top: auto;
        }

        .footer-content {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }

        .footer-sections {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 30px;
            margin-bottom: 30px;
        }

        .footer-section h5 {
            margin-bottom: 15px;
            font-size: 16px;
        }

        .footer-section ul {
            list-style: none;
        }

        .footer-section li {
            margin-bottom: 8px;
        }

        .footer-section a {
            color: #ecf0f1;
            text-decoration: none;
        }

        .footer-section a:hover {
            color: #3498db;
        }

        .footer-bottom {
            text-align: center;
            padding-top: 20px;
            border-top: 1px solid rgba(255,255,255,0.1);
            color: rgba(255,255,255,0.7);
            font-size: 14px;
        }

        /* Адаптивность */
        @media (max-width: 768px) {
            .header-top {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
            
            .nav-menu {
                gap: 10px;
            }
            
            .nav-menu a {
                padding: 6px 10px;
                font-size: 14px;
            }
            
            .user-panel {
                flex-direction: column;
                text-align: center;
                gap: 10px;
            }
            
            .main-content {
                padding: 20px 0;
            }
            
            .footer-sections {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
<?php $this->beginBody() ?>

<!-- ШАПКА САЙТА - ПРОСТАЯ И НАДЕЖНАЯ -->
<header class="site-header">
    <div class="header-content">
        <!-- Первая строка: логотип и кнопки входа -->
        <div class="header-top">
            <a href="<?= Yii::$app->homeUrl ?>" class="site-logo">
                <i class="fas fa-mountain"></i>
                <span>Туры выходного дня</span>
            </a>
            
            <?php if (Yii::$app->user->isGuest): ?>
                <div class="auth-buttons">
                    <a href="<?= Yii::$app->urlManager->createUrl(['auth/login']) ?>" class="btn btn-primary">
                        <i class="fas fa-sign-in-alt"></i> Вход
                    </a>
                    <a href="<?= Yii::$app->urlManager->createUrl(['auth/register']) ?>" class="btn btn-outline">
                        <i class="fas fa-user-plus"></i> Регистрация
                    </a>
                </div>
            <?php else: ?>
                <!-- Панель пользователя -->
                <div class="user-panel">
                    <div class="user-avatar">
                        <i class="fas fa-user-circle"></i>
                    </div>
                    <div class="user-details">
                        <div class="user-name">
                            <?= Html::encode(Yii::$app->user->identity->full_name) ?>
                            <span class="user-role <?= Yii::$app->user->identity->isAdmin() ? 'admin' : '' ?>">
                                <?= Yii::$app->user->identity->isAdmin() ? 'Админ' : 'Пользователь' ?>
                            </span>
                        </div>
                        <div class="user-email"><?= Html::encode(Yii::$app->user->identity->email) ?></div>
                    </div>
                    <form action="<?= Yii::$app->urlManager->createUrl(['auth/logout']) ?>" method="post" class="logout-form">
                        <input type="hidden" name="<?= Yii::$app->request->csrfParam ?>" value="<?= Yii::$app->request->csrfToken ?>">
                        <button type="submit" class="btn btn-danger">
                            <i class="fas fa-sign-out-alt"></i> Выход
                        </button>
                    </form>
                </div>
            <?php endif; ?>
        </div>
        
        <!-- Вторая строка: основное меню -->
        <nav class="main-nav">
            <ul class="nav-menu">
                <li><a href="<?= Yii::$app->homeUrl ?>">
                    <i class="fas fa-home"></i> Главная
                </a></li>
                
                <li><a href="<?= Yii::$app->urlManager->createUrl(['tour/index']) ?>">
                    <i class="fas fa-compass"></i> Каталог туров
                </a></li>
                
                <?php if (!Yii::$app->user->isGuest): ?>
    <li><a href="<?= Yii::$app->urlManager->createUrl(['application/my-applications']) ?>">
        <i class="fas fa-clipboard-list"></i> Мои заявки
    </a></li>
    
    <li><a href="<?= Yii::$app->urlManager->createUrl(['application/create']) ?>">
        <i class="fas fa-plus-circle"></i> Новая заявка
    </a></li>
    
    <?php if (Yii::$app->user->identity->isAdmin()): ?>
        <li><a href="#">
            <i class="fas fa-cogs"></i> Админ-панель
        </a></li>
    <?php endif; ?>
<?php endif; ?>
                
                <li><a href="#">
                    <i class="fas fa-info-circle"></i> О нас
                </a></li>
                
                <li><a href="#">
                    <i class="fas fa-envelope"></i> Контакты
                </a></li>
            </ul>
        </nav>
    </div>
</header>

<!-- ОСНОВНОЙ КОНТЕНТ -->
<main class="main-content">
    <div class="container">
        <!-- Сообщения системы -->
        <?php if (Yii::$app->session->hasFlash('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <?= Yii::$app->session->getFlash('success') ?>
            </div>
        <?php endif; ?>

        <?php if (Yii::$app->session->hasFlash('error')): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle"></i>
                <?= Yii::$app->session->getFlash('error') ?>
            </div>
        <?php endif; ?>

        <?php if (Yii::$app->session->hasFlash('info')): ?>
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i>
                <?= Yii::$app->session->getFlash('info') ?>
            </div>
        <?php endif; ?>

        <!-- Контент страницы -->
        <?= $content ?>
    </div>
</main>

<!-- ПОДВАЛ -->
<footer class="site-footer">
    <div class="footer-content">
        <div class="footer-sections">
            <div class="footer-section">
                <h5><i class="fas fa-mountain"></i> Туры выходного дня</h5>
                <p>Лучшие туры по Уралу для вашего идеального отдыха</p>
            </div>
            
            <div class="footer-section">
                <h5>Навигация</h5>
                <ul>
                    <li><a href="<?= Yii::$app->homeUrl ?>">Главная</a></li>
                    <li><a href="<?= Yii::$app->urlManager->createUrl(['tour/index']) ?>">Каталог туров</a></li>
                    <li><a href="#">О нас</a></li>
                    <li><a href="#">Контакты</a></li>
                </ul>
            </div>
            
            <div class="footer-section">
                <h5>Аккаунт</h5>
                <ul>
                    <li><a href="<?= Yii::$app->urlManager->createUrl(['auth/login']) ?>">Вход</a></li>
                    <li><a href="<?= Yii::$app->urlManager->createUrl(['auth/register']) ?>">Регистрация</a></li>
                </ul>
            </div>
            
            <div class="footer-section">
                <h5>Контакты</h5>
                <p><i class="fas fa-phone"></i> +7(343) 123-45-67</p>
                <p><i class="fas fa-envelope"></i> info@tours-weekend.ru</p>
                <p><i class="fas fa-map-marker-alt"></i> г. Екатеринбург</p>
            </div>
        </div>
        
        <div class="footer-bottom">
            <p>&copy; <?= date('Y') ?> Туры выходного дня. Все права защищены.</p>
        </div>
    </div>
</footer>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Подтверждение выхода
    const logoutForms = document.querySelectorAll('.logout-form');
    logoutForms.forEach(form => {
        form.addEventListener('submit', function(e) {
            if (!confirm('Вы действительно хотите выйти?')) {
                e.preventDefault();
            }
        });
    });

    // Автоматическое скрытие сообщений через 5 секунд
    const alerts = document.querySelectorAll('.alert');
    alerts.forEach(alert => {
        setTimeout(() => {
            alert.style.transition = 'opacity 0.3s';
            alert.style.opacity = '0';
            setTimeout(() => {
                if (alert.parentNode) {
                    alert.parentNode.removeChild(alert);
                }
            }, 300);
        }, 5000);
    });
});
</script>
<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>