<?php

use yii\helpers\Html;

$this->title = 'Заявка #' . $application->id;
?>
<div class="application-view">
    <div class="card">
        <div class="card-header">
            <h2><i class="fas fa-file-alt"></i> <?= Html::encode($this->title) ?></h2>
        </div>
        
        <div class="card-body">
            <div class="application-detail">
                <div class="detail-section">
                    <h3><i class="fas fa-info-circle"></i> Основная информация</h3>
                    <div class="detail-grid">
                        <div class="detail-item">
                            <div class="detail-label">Тур:</div>
                            <div class="detail-value"><?= Html::encode($application->tour->name) ?></div>
                        </div>
                        <div class="detail-item">
                            <div class="detail-label">Дата тура:</div>
                            <div class="detail-value"><?= $application->getFormattedTourDate() ?></div>
                        </div>
                        <div class="detail-item">
                            <div class="detail-label">Количество участников:</div>
                            <div class="detail-value"><?= $application->participants_count ?> человек</div>
                        </div>
                        <div class="detail-item">
                            <div class="detail-label">Общая стоимость:</div>
                            <div class="detail-value"><strong><?= $application->getFormattedTotalPrice() ?></strong></div>
                        </div>
                        <div class="detail-item">
                            <div class="detail-label">Статус:</div>
                            <div class="detail-value">
                                <span class="status-badge status-<?= $application->status ?>">
                                    <?= $application->getStatusLabel() ?>
                                </span>
                            </div>
                        </div>
                        <div class="detail-item">
                            <div class="detail-label">Способ оплаты:</div>
                            <div class="detail-value"><?= Html::encode($application->getPaymentMethodLabel()) ?></div>
                        </div>
                        <div class="detail-item">
                            <div class="detail-label">Дата создания:</div>
                            <div class="detail-value"><?= $application->getFormattedCreatedAt() ?></div>
                        </div>
                    </div>
                </div>

                <?php if ($application->comment): ?>
                <div class="detail-section">
                    <h3><i class="fas fa-comment"></i> Ваш комментарий</h3>
                    <div class="detail-content">
                        <?= nl2br(Html::encode($application->comment)) ?>
                    </div>
                </div>
                <?php endif; ?>

                <?php if ($application->wishes): ?>
                <div class="detail-section">
                    <h3><i class="fas fa-star"></i> Ваши пожелания</h3>
                    <div class="detail-content">
                        <?= nl2br(Html::encode($application->wishes)) ?>
                    </div>
                </div>
                <?php endif; ?>

                <?php if ($application->admin_comment): ?>
                <div class="detail-section">
                    <h3><i class="fas fa-user-tie"></i> Комментарий администратора</h3>
                    <div class="detail-content admin-comment">
                        <?= nl2br(Html::encode($application->admin_comment)) ?>
                    </div>
                </div>
                <?php endif; ?>

                <div class="detail-section">
                    <h3><i class="fas fa-user"></i> Контактная информация</h3>
                    <div class="detail-grid">
                        <div class="detail-item">
                            <div class="detail-label">ФИО:</div>
                            <div class="detail-value"><?= Html::encode(Yii::$app->user->identity->full_name) ?></div>
                        </div>
                        <div class="detail-item">
                            <div class="detail-label">Email:</div>
                            <div class="detail-value"><?= Html::encode(Yii::$app->user->identity->email) ?></div>
                        </div>
                        <div class="detail-item">
                            <div class="detail-label">Телефон:</div>
                            <div class="detail-value"><?= Html::encode($application->contact_phone) ?></div>
                        </div>
                    </div>
                </div>

                <div class="application-actions mt-4">
                    <?= Html::a('Вернуться к списку заявок', ['my-applications'], [
                        'class' => 'btn btn-primary'
                    ]) ?>
                    
                    <?php if ($application->canBeCancelled()): ?>
                        <?= Html::a('Отменить заявку', ['cancel', 'id' => $application->id], [
                            'class' => 'btn btn-danger',
                            'data' => [
                                'confirm' => 'Вы уверены, что хотите отменить эту заявку?',
                                'method' => 'post',
                            ]
                        ]) ?>
                    <?php endif; ?>
                    
                    <?= Html::a('Создать новую заявку', ['create'], [
                        'class' => 'btn btn-success'
                    ]) ?>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.application-view {
    padding: 20px 0;
}

.detail-section {
    margin-bottom: 30px;
    padding-bottom: 20px;
    border-bottom: 1px solid #eee;
}

.detail-section:last-child {
    border-bottom: none;
}

.detail-section h3 {
    color: #2c3e50;
    margin-bottom: 15px;
    display: flex;
    align-items: center;
    gap: 10px;
}

.detail-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
    gap: 15px;
}

.detail-item {
    display: flex;
    flex-direction: column;
    gap: 5px;
}

.detail-label {
    font-weight: bold;
    color: #7f8c8d;
    font-size: 14px;
}

.detail-value {
    color: #2c3e50;
    font-size: 16px;
}

.detail-content {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 6px;
    border-left: 4px solid #3498db;
    line-height: 1.6;
}

.admin-comment {
    border-left-color: #e74c3c;
    background: #fff5f5;
}

.application-actions {
    display: flex;
    gap: 15px;
    flex-wrap: wrap;
}

@media (max-width: 768px) {
    .detail-grid {
        grid-template-columns: 1fr;
    }
    
    .application-actions {
        flex-direction: column;
    }
    
    .application-actions .btn {
        width: 100%;
    }
}
</style>