<?php

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Мои заявки';
?>
<div class="my-applications">
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h2><i class="fas fa-clipboard-list"></i> <?= Html::encode($this->title) ?></h2>
                <?= Html::a('<i class="fas fa-plus-circle"></i> Новая заявка', ['create'], [
                    'class' => 'btn btn-success'
                ]) ?>
            </div>
        </div>
        
        <div class="card-body">
            <?php if (Yii::$app->session->hasFlash('success')): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i>
                    <?= Yii::$app->session->getFlash('success') ?>
                </div>
            <?php endif; ?>

            <?php if (empty($applications)): ?>
                <div class="empty-state">
                    <i class="fas fa-clipboard fa-3x"></i>
                    <h3>У вас пока нет заявок</h3>
                    <p>Создайте свою первую заявку на тур!</p>
                    <?= Html::a('Создать заявку', ['create'], [
                        'class' => 'btn btn-primary btn-lg'
                    ]) ?>
                </div>
            <?php else: ?>
                <div class="applications-list">
                    <?php foreach ($applications as $application): ?>
                    <div class="application-item">
                        <div class="application-header">
                            <div class="application-info">
                                <h3><?= Html::encode($application->tour->name) ?></h3>
                                <div class="application-meta">
                                    <span class="application-date">
                                        <i class="fas fa-calendar"></i> <?= $application->getFormattedTourDate() ?>
                                    </span>
                                    <span class="application-participants">
                                        <i class="fas fa-users"></i> <?= $application->participants_count ?> чел.
                                    </span>
                                    <span class="application-price">
                                        <i class="fas fa-money-bill-wave"></i> <?= $application->getFormattedTotalPrice() ?>
                                    </span>
                                </div>
                            </div>
                            <div class="application-status">
                                <span class="status-badge status-<?= $application->status ?>">
                                    <?= $application->getStatusLabel() ?>
                                </span>
                            </div>
                        </div>
                        
                        <div class="application-details">
                            <div class="detail-row">
                                <div class="detail-label">Создана:</div>
                                <div class="detail-value"><?= $application->getFormattedCreatedAt() ?></div>
                            </div>
                            <div class="detail-row">
                                <div class="detail-label">Способ оплаты:</div>
                                <div class="detail-value"><?= Html::encode($application->getPaymentMethodLabel()) ?></div>
                            </div>
                            <?php if ($application->comment): ?>
                                <div class="detail-row">
                                    <div class="detail-label">Комментарий:</div>
                                    <div class="detail-value"><?= nl2br(Html::encode($application->comment)) ?></div>
                                </div>
                            <?php endif; ?>
                            <?php if ($application->admin_comment): ?>
                                <div class="detail-row">
                                    <div class="detail-label">Комментарий администратора:</div>
                                    <div class="detail-value admin-comment"><?= nl2br(Html::encode($application->admin_comment)) ?></div>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="application-actions">
                            <?= Html::a('Подробнее', ['view', 'id' => $application->id], [
                                'class' => 'btn btn-outline'
                            ]) ?>
                            
                            <?php if ($application->canBeCancelled()): ?>
                                <?= Html::a('Отменить заявку', ['cancel', 'id' => $application->id], [
                                    'class' => 'btn btn-danger',
                                    'data' => [
                                        'confirm' => 'Вы уверены, что хотите отменить эту заявку?',
                                        'method' => 'post',
                                    ]
                                ]) ?>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
            
            <div class="mt-4">
                <?= Html::a('Вернуться в каталог', ['tour/index'], [
                    'class' => 'btn btn-primary'
                ]) ?>
            </div>
        </div>
    </div>
</div>

<style>
.my-applications {
    padding: 20px 0;
}

.d-flex {
    display: flex;
}

.justify-content-between {
    justify-content: space-between;
}

.align-items-center {
    align-items: center;
}

.empty-state {
    text-align: center;
    padding: 40px 20px;
    color: #7f8c8d;
}

.empty-state i {
    margin-bottom: 20px;
}

.empty-state h3 {
    margin-bottom: 10px;
}

.applications-list {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.application-item {
    background: white;
    border: 1px solid #ddd;
    border-radius: 6px;
    padding: 20px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
}

.application-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 15px;
    padding-bottom: 15px;
    border-bottom: 1px solid #eee;
}

.application-info h3 {
    font-size: 18px;
    color: #2c3e50;
    margin-bottom: 10px;
}

.application-meta {
    display: flex;
    gap: 20px;
    color: #7f8c8d;
    font-size: 14px;
}

.application-meta i {
    margin-right: 5px;
}

.application-status {
    text-align: right;
}

.status-badge {
    padding: 5px 15px;
    border-radius: 20px;
    font-size: 14px;
    font-weight: bold;
}

.status-new {
    background: #95a5a6;
    color: white;
}

.status-processing {
    background: #3498db;
    color: white;
}

.status-accepted {
    background: #27ae60;
    color: white;
}

.status-rejected {
    background: #e74c3c;
    color: white;
}

.status-cancelled {
    background: #f39c12;
    color: white;
}

.application-details {
    margin-bottom: 15px;
}

.detail-row {
    display: flex;
    margin-bottom: 10px;
}

.detail-label {
    flex: 0 0 200px;
    font-weight: bold;
    color: #2c3e50;
}

.detail-value {
    flex: 1;
    color: #5d6d7e;
}

.admin-comment {
    color: #e74c3c;
    font-style: italic;
}

.application-actions {
    display: flex;
    gap: 10px;
    justify-content: flex-end;
    padding-top: 15px;
    border-top: 1px solid #eee;
}

@media (max-width: 768px) {
    .application-header {
        flex-direction: column;
        gap: 10px;
    }
    
    .application-status {
        text-align: left;
    }
    
    .application-meta {
        flex-direction: column;
        gap: 5px;
    }
    
    .detail-row {
        flex-direction: column;
        gap: 5px;
    }
    
    .detail-label {
        flex: none;
    }
    
    .application-actions {
        flex-direction: column;
    }
    
    .application-actions .btn {
        width: 100%;
    }
}
</style>