<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

$this->title = 'Новая заявка';
?>
<div class="application-create">
    <div class="card">
        <div class="card-header">
            <h2><i class="fas fa-calendar-plus"></i> <?= Html::encode($this->title) ?></h2>
        </div>
        
        <div class="card-body">
            <?php if (Yii::$app->session->hasFlash('error')): ?>
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-circle"></i>
                    <?= Yii::$app->session->getFlash('error') ?>
                </div>
            <?php endif; ?>

            <?php $form = ActiveForm::begin([
                'id' => 'application-form',
            ]); ?>

            <div class="form-row">
                <div class="form-group col-md-6">
                    <?= $form->field($model, 'tour_id')->dropDownList(
                        \yii\helpers\ArrayHelper::map($tours, 'id', 'name'),
                        [
                            'prompt' => 'Выберите тур...',
                            'class' => 'form-control'
                        ]
                    )->label('Тур') ?>
                </div>
                
                <div class="form-group col-md-6">
                    <?= $form->field($model, 'tour_date')->input('date', [
                        'class' => 'form-control',
                        'min' => date('Y-m-d', strtotime('+1 day'))
                    ])->label('Дата тура') ?>
                    <small class="form-text text-muted">Минимальная дата: завтра</small>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group col-md-6">
                    <?= $form->field($model, 'participants_count')->input('number', [
                        'class' => 'form-control',
                        'min' => 1,
                        'max' => 20,
                        'value' => 1
                    ])->label('Количество участников') ?>
                </div>
                
                <div class="form-group col-md-6">
                    <?= $form->field($model, 'payment_method')->dropDownList(
                        \app\models\Application::getPaymentMethods(),
                        [
                            'prompt' => 'Выберите способ оплаты...',
                            'class' => 'form-control'
                        ]
                    )->label('Способ оплаты') ?>
                </div>
            </div>

            <div class="form-group">
                <?= $form->field($model, 'comment')->textarea([
                    'rows' => 3,
                    'class' => 'form-control',
                    'placeholder' => 'Дополнительная информация, особые пожелания...'
                ])->label('Комментарий') ?>
            </div>

            <div class="form-group">
                <?= $form->field($model, 'wishes')->textarea([
                    'rows' => 3,
                    'class' => 'form-control',
                    'placeholder' => 'Особые требования, аллергии, предпочтения в питании...'
                ])->label('Пожелания') ?>
            </div>

            <div class="alert alert-info">
                <h4><i class="fas fa-info-circle"></i> Информация о заявке</h4>
                <p><strong>Контактный телефон:</strong> <?= Html::encode(Yii::$app->user->identity->phone) ?></p>
                <p><strong>Email:</strong> <?= Html::encode(Yii::$app->user->identity->email) ?></p>
                <p><strong>ФИО:</strong> <?= Html::encode(Yii::$app->user->identity->full_name) ?></p>
            </div>

            <div class="form-group">
                <?= Html::submitButton('Отправить заявку', [
                    'class' => 'btn btn-success btn-lg btn-block',
                    'name' => 'submit-button'
                ]) ?>
            </div>

            <?php ActiveForm::end(); ?>

            <div class="mt-4">
                <?= Html::a('Вернуться к каталогу туров', ['tour/index'], [
                    'class' => 'btn btn-outline'
                ]) ?>
                <?= Html::a('Мои заявки', ['my-applications'], [
                    'class' => 'btn btn-primary'
                ]) ?>
            </div>
        </div>
    </div>
</div>

<style>
.application-create {
    padding: 20px 0;
}

.form-row {
    display: flex;
    flex-wrap: wrap;
    margin: 0 -10px;
}

.form-group {
    padding: 0 10px;
    margin-bottom: 20px;
    flex: 1 0 100%;
}

.form-group.col-md-6 {
    flex: 0 0 50%;
    max-width: 50%;
}

.form-control {
    width: 100%;
    padding: 10px;
    border: 1px solid #ddd;
    border-radius: 4px;
    font-size: 16px;
}

.form-control:focus {
    border-color: #3498db;
    outline: none;
    box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
}

label {
    display: block;
    margin-bottom: 5px;
    font-weight: bold;
    color: #2c3e50;
}

.help-block {
    color: #e74c3c;
    font-size: 14px;
    margin-top: 5px;
}

@media (max-width: 768px) {
    .form-group.col-md-6 {
        flex: 0 0 100%;
        max-width: 100%;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Устанавливаем минимальную дату - завтра
    const dateInput = document.querySelector('input[type="date"]');
    if (dateInput) {
        const tomorrow = new Date();
        tomorrow.setDate(tomorrow.getDate() + 1);
        dateInput.min = tomorrow.toISOString().split('T')[0];
    }

    // Валидация формы
    const form = document.getElementById('application-form');
    if (form) {
        form.addEventListener('submit', function(e) {
            const tourId = document.querySelector('select[name="Application[tour_id]"]');
            const tourDate = document.querySelector('input[name="Application[tour_date]"]');
            const participants = document.querySelector('input[name="Application[participants_count]"]');
            
            let isValid = true;
            
            // Сброс ошибок
            [tourId, tourDate, participants].forEach(field => {
                field.classList.remove('has-error');
                const errorElement = field.parentNode.querySelector('.help-block');
                if (errorElement) {
                    errorElement.remove();
                }
            });
            
            // Проверка выбора тура
            if (!tourId.value) {
                showError(tourId, 'Выберите тур');
                isValid = false;
            }
            
            // Проверка даты
            if (!tourDate.value) {
                showError(tourDate, 'Выберите дату тура');
                isValid = false;
            }
            
            // Проверка количества участников
            if (!participants.value || participants.value < 1 || participants.value > 20) {
                showError(participants, 'Введите количество участников от 1 до 20');
                isValid = false;
            }
            
            if (!isValid) {
                e.preventDefault();
                // Прокрутка к первой ошибке
                const firstError = form.querySelector('.has-error');
                if (firstError) {
                    firstError.scrollIntoView({ behavior: 'smooth', block: 'center' });
                }
            }
        });
    }
    
    function showError(field, message) {
        field.classList.add('has-error');
        const errorDiv = document.createElement('div');
        errorDiv.className = 'help-block';
        errorDiv.textContent = message;
        field.parentNode.appendChild(errorDiv);
    }
});
</script>