<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;

class Tour extends ActiveRecord
{
    public static function tableName()
    {
        return 'tour'; // Название таблицы из миграции
    }

    public function rules()
    {
        return [
            [['name', 'description', 'price'], 'required'],
            [['description', 'program', 'short_description'], 'string'],
            [['price'], 'number'],
            [['duration_days', 'max_participants', 'is_active'], 'integer'],
            [['name'], 'string', 'max' => 200],
            [['image'], 'string', 'max' => 255],
        ];
    }

    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Название',
            'description' => 'Описание',
            'price' => 'Цена',
            'duration_days' => 'Дней',
            'image' => 'Изображение',
            'is_active' => 'Активен',
        ];
    }

    // Получаем активные туры
    public static function getActiveTours()
    {
        return self::find()->where(['is_active' => 1])->all();
    }

    // Форматированная цена
    public function getFormattedPrice()
    {
        return number_format($this->price, 0, ',', ' ') . ' ₽';
    }
}