<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%profile_review}}`.
 */
class m260206_180311_create_profile_review_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%review}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'tour_id' => $this->integer()->notNull(),
            'application_id' => $this->integer(),
            'rating' => $this->integer()->notNull(),
            'comment' => $this->text()->notNull(),
            'is_published' => $this->boolean()->defaultValue(true),
            'created_at' => $this->integer()->notNull(),
        ], $tableOptions);

        // Создаем индексы и внешние ключи
        $this->createIndex('idx-review-user_id', '{{%review}}', 'user_id');
        $this->createIndex('idx-review-tour_id', '{{%review}}', 'tour_id');
        $this->createIndex('idx-review-application_id', '{{%review}}', 'application_id');
        $this->createIndex('idx-review-rating', '{{%review}}', 'rating');
        $this->createIndex('idx-review-is_published', '{{%review}}', 'is_published');

        $this->addForeignKey(
            'fk-review-user_id',
            '{{%review}}',
            'user_id',
            '{{%user}}',
            'id',
            'CASCADE',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk-review-tour_id',
            '{{%review}}',
            'tour_id',
            '{{%tour}}',
            'id',
            'CASCADE',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk-review-application_id',
            '{{%review}}',
            'application_id',
            '{{%application}}',
            'id',
            'SET NULL',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%profile_review}}');
    }
}
