<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%profile_tour}}`.
 */
class m260206_180248_create_profile_tour_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%application}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'tour_id' => $this->integer()->notNull(),
            'tour_date' => $this->date()->notNull(),
            'participants_count' => $this->integer()->notNull(),
            'contact_phone' => $this->string(20),
            'comment' => $this->text(),
            'payment_method' => $this->string(50),
            'wishes' => $this->text(),
            'status' => $this->string(20)->notNull()->defaultValue('new'),
            'admin_comment' => $this->text(),
            'created_at' => $this->integer()->notNull(),
            'updated_at' => $this->integer()->notNull(),
        ], $tableOptions);

        // Создаем индексы и внешние ключи
        $this->createIndex('idx-application-user_id', '{{%application}}', 'user_id');
        $this->createIndex('idx-application-tour_id', '{{%application}}', 'tour_id');
        $this->createIndex('idx-application-status', '{{%application}}', 'status');
        $this->createIndex('idx-application-tour_date', '{{%application}}', 'tour_date');

        $this->addForeignKey(
            'fk-application-user_id',
            '{{%application}}',
            'user_id',
            '{{%user}}',
            'id',
            'CASCADE',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk-application-tour_id',
            '{{%application}}',
            'tour_id',
            '{{%tour}}',
            'id',
            'CASCADE',
            'CASCADE'
        );
    }


    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%profile_tour}}');
    }
}
