<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use app\models\Tour;
use app\models\Review;

class TourController extends Controller
{
    public function actionIndex()
    {
        $tours = Tour::find()->where(['is_active' => 1])->all();
        
        return $this->render('index', [
            'tours' => $tours,
        ]);
    }

    public function actionView($id)
    {
        $tour = Tour::findOne($id);
        
        if (!$tour) {
            throw new \yii\web\NotFoundHttpException('Тур не найден');
        }
        
        return $this->render('view', [
            'tour' => $tour,
        ]);
    }
}