<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\Application;
use app\models\Tour;

class ApplicationController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'], // Только для авторизованных
                    ],
                ],
            ],
        ];
    }

    /**
     * Создание новой заявки
     */
    public function actionCreate($tour_id = null)
    {
        $model = new Application();
        $model->user_id = Yii::$app->user->id;
        
        // Если передан tour_id, устанавливаем его
        if ($tour_id) {
            $tour = Tour::findOne($tour_id);
            if ($tour) {
                $model->tour_id = $tour_id;
            }
        }

        if ($model->load(Yii::$app->request->post())) {
            // Устанавливаем контактный телефон из профиля пользователя
            $model->contact_phone = Yii::$app->user->identity->phone;
            
            if ($model->save()) {
                Yii::$app->session->setFlash('success', 
                    'Заявка успешно создана! Мы свяжемся с вами для подтверждения.'
                );
                return $this->redirect(['my-applications']);
            } else {
                Yii::$app->session->setFlash('error', 
                    'Пожалуйста, исправьте ошибки в форме.'
                );
            }
        }

        // Получаем список активных туров для выпадающего списка
        $tours = Tour::find()->where(['is_active' => 1])->all();
        
        return $this->render('create', [
            'model' => $model,
            'tours' => $tours,
        ]);
    }

    /**
     * Страница "Мои заявки"
     */
    public function actionMyApplications()
    {
        $applications = Application::find()
            ->where(['user_id' => Yii::$app->user->id])
            ->with('tour')
            ->orderBy(['created_at' => SORT_DESC])
            ->all();

        return $this->render('my-applications', [
            'applications' => $applications,
        ]);
    }

    /**
     * Отмена заявки
     */
    public function actionCancel($id)
    {
        $application = Application::findOne(['id' => $id, 'user_id' => Yii::$app->user->id]);
        
        if (!$application) {
            throw new \yii\web\NotFoundHttpException('Заявка не найдена');
        }

        if ($application->canBeCancelled()) {
            $application->status = Application::STATUS_CANCELLED;
            if ($application->save()) {
                Yii::$app->session->setFlash('success', 'Заявка успешно отменена.');
            } else {
                Yii::$app->session->setFlash('error', 'Ошибка при отмене заявки.');
            }
        } else {
            Yii::$app->session->setFlash('error', 'Невозможно отменить заявку с текущим статусом.');
        }

        return $this->redirect(['my-applications']);
    }

    /**
     * Просмотр деталей заявки
     */
    public function actionView($id)
    {
        $application = Application::findOne(['id' => $id, 'user_id' => Yii::$app->user->id]);
        
        if (!$application) {
            throw new \yii\web\NotFoundHttpException('Заявка не найдена');
        }

        return $this->render('view', [
            'application' => $application,
        ]);
    }
}